﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_UpdateRespondentIntervCallWithGroup]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_UpdateRespondentIntervCallWithGroup]
GO

CREATE PROCEDURE [dbo].[sp_UpdateRespondentIntervCallWithGroup] 
	@synchedRespondents AS [dbo].[RespondentsIdList] READONLY
AS
BEGIN
    UPDATE Respondent
    SET  ResIntervCall = (CASE WHEN qtgroup = 0 THEN '' WHEN qtgroup < 10 THEN 'G0' + CAST(qtgroup AS VARCHAR) ELSE 'G' + CAST(qtgroup AS VARCHAR) END) 
    FROM Respondent 
	INNER JOIN @synchedRespondents sr ON sr.Id = ResRespondent
    INNER JOIN (
		SELECT StrRespondent as respondent, MAX(qtgroup) qtgroup 
		FROM Stratum WITH (NOLOCK) 
		INNER JOIN Quota WITH (NOLOCK) on StrQuotaid = QtQuotaId 
		GROUP BY StrRespondent
	) qt on sr.Id = qt.respondent
    WHERE ResCall = 0
		AND (ResIntervCall = '' OR ResIntervCall = '***' OR ResIntervCall LIKE 'G[0-9][0-9]')
		AND ResIntervCall <> (CASE WHEN qtgroup = 0  THEN '' WHEN qtgroup < 10 THEN 'G0' + CAST(qtgroup AS VARCHAR) ELSE 'G' + CAST(qtgroup AS VARCHAR) END)
END
GO
